import java.sql.*;
import java.io.*;

public class Main
{
  public static void main(String args[])
  {
    if (args.length < 2){
      System.out.println(
        "Wywoanie programu: 'Main nazwa_pliku nazwa_tabeli'");
      System.exit(0);
    }
    PrintWriter fs = null;
    try{
      fs = new PrintWriter(new FileOutputStream(args[0]), true);
    }
    catch(FileNotFoundException e){
      System.out.println("Nie mona utworzy pliku: " + args[0]);
      System.exit(-1);
    }
    Connection conn = DBConnection.getConnection(
      "jdbc:mysql://localhost:3306/test", "test", "test");
    if(conn == null){
      System.exit(-1);
    }
    try{
      String query = "SELECT * FROM " + args[1];
      Statement stm = conn.createStatement();
      ResultSet rs = stm.executeQuery(query);
      ResultSetMetaData rsmd = rs.getMetaData();
      int colsNo = rsmd.getColumnCount();
      while(rs.next()){
        String result = "";
        for(int i = 1; i <= colsNo; i++){
          result += rs.getString(i);
          result += i < colsNo ? " | " : "";
        }
        fs.println(result);
      }
    }
    catch(SQLException e){
      System.out.println("Bd przy przetwarzaniu danych: " + e);
    }
    try{
      conn.close();
    }
    catch(SQLException e){
      System.out.println("Bd przy zamykaniu poczenia: " + e);
    }
  }
}
